{ *********************************************************************** }
{                                                                         }
{ Delphi Visual Component Library                                         }
{                                                                         }
{ Copyright (c) 1995-2004 Borland Software Corporation                    }
{                                                                         }
{ *********************************************************************** }

{*******************************************************}
{       MS Transaction Server Interface Unit            }
{*******************************************************}

unit Borland.Vcl.Mtx;

{$H+,X+}
{$WEAKPACKAGEUNIT}

interface

uses Windows, Variants, System.Runtime.InteropServices, System.Text;

const

{ Trappable Error Codes }

  mtsErrCtxAborted         = $8004E002;
  mtsErrCtxAborting        = $8004E003;
  mtsErrCtxNoContext       = $8004E004;
  mtsErrCtxNotRegistered   = $8004E005;
  mtsErrCtxActivityTimeout = $8004E006;
  mtsErrCtxOldReference    = $8004E007;
  mtsErrCtxRoleNotFound    = $8004E00C;
  mtsErrCtxNoSecurity      = $8004E00D;
  mtsErrCtxWrongThread     = $8004E00E;
  mtsErrCtxTMNotAvailable  = $8004E00F;

{ Component class GUIDs }

  CLASS_TransactionContext{: TGUID} = '{7999FC25-D3C6-11CF-ACAB-00A024A55AEF}';
  CLASS_TransactionContextEx{: TGUID} = '{5CB66670-D3D4-11CF-ACAB-00A024A55AEF}';
  CLASS_SharedPropertyGroupManager{: TGUID} = '{2A005C11-A5DE-11CF-9E66-00AA00A3F464}';

const
  LockSetGet = $00000000;
  LockMethod = $00000001;

  Standard = $00000000;
  Process  = $00000001;

type

{ Forward declarations: Interfaces }
  IObjectContext = interface;
  IGetContextProperties = interface;
  IEnumNames = interface;
  ISecurityProperty = interface;
  IObjectControl = interface;
  IObjectContextActivity = interface;

  ITransactionContext = interface;
  ITransactionContextEx = interface;

  ISharedProperty = interface;
  ISharedPropertyGroup = interface;
  ISharedPropertyGroupManager = interface;

{ IObjectContext }

  [ComImport,
  GuidAttribute('51372AE0-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectContext = interface
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.LPStruct)] cid,
      [MarshalAs(UnmanagedType.LPStruct)] rid: TGUID;
      [MarshalAs(UnmanagedType.Interface)] out pv): HResult;
    procedure SetComplete;
    procedure SetAbort;
    procedure EnableCommit;
    procedure DisableCommit;
    [PreserveSig]
    function IsInTransaction: Bool;
    [PreserveSig]
    function IsSecurityEnabled: Bool;
    function IsCallerInRole(const bstrRole: WideString): Bool;
  end;

{ IGetContextProperties }

  [ComImport,
  GuidAttribute('51372AF4-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IGetContextProperties = interface  //!! Make these all safecall???
    function Count: Integer;
    function GetProperty(const name: WideString): OleVariant;
    function EnumNames: IEnumNames;
  end;

{ IEnumNames }

  [ComImport,
  GuidAttribute('51372AF2-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IEnumNames = interface
    [PreserveSig]
    function Next(celt: UINT; out rgname: StringBuilder;
      out pceltFetched: UINT): HResult;
    [PreserveSig]
    function Skip(celt: UINT): HResult;
    [PreserveSig]
    function Reset: HResult;
    [PreserveSig]
    function Clone(out enm: IEnumNames): HResult;
  end;

{ ISecurityProperty }

  [ComImport,
  GuidAttribute('51372AEA-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ISecurityProperty = interface
    [PreserveSig]
    function GetDirectCreatorSID(out sid: PSID): HResult;
    [PreserveSig]
    function GetOriginalCreatorSID(out sid: PSID): HResult;
    [PreserveSig]
    function GetDirectCallerSID(out sid: PSID): HResult;
    [PreserveSig]
    function GetOriginalCallerSID(out sid: PSID): HResult;
    [PreserveSig]
    function ReleaseSID(sid: PSID): HResult;
  end;

{ IObjectControl }

  [ComImport,
  GuidAttribute('51372AEC-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectControl = interface
    procedure Activate;
    [PreserveSig]
    procedure Deactivate;
    [PreserveSig]
    function CanBePooled: Bool;
  end;

{ IObjectContextActivity }

  [ComImport,
  GuidAttribute('51372AFC-CAE7-11CF-BE81-00AA00A2FA25'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  IObjectContextActivity = interface
    function GetActivityId: TGuid;
  end;

{ ITransactionContext }

  [ComImport,
  GuidAttribute('7999FC21-D3C6-11CF-ACAB-00A024A55AEF'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  ITransactionContext = interface
    function CreateInstance([in] var pszProgId: WideString): OleVariant;
    procedure Commit;
    procedure Abort;
  end;

{ ITransactionContextEx }

  [ComImport,
  GuidAttribute('7999FC22-D3C6-11CF-ACAB-00A024A55AEF'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIUnknown)]
  ITransactionContextEx = interface
    [PreserveSig]
    function CreateInstance([MarshalAs(UnmanagedType.LPStruct)] cid,
      [MarshalAs(UnmanagedType.LPStruct)] rid: TGUID;
      [MarshalAs(UnmanagedType.Interface)] out pv): HRESULT;
    [PreserveSig]
    function Commit: HResult;
    [PreserveSig]
    function Abort: HResult;
  end;

{ ISharedProperty }

  [ComImport,
  GuidAttribute('2A005C01-A5DE-11CF-9E66-00AA00A3F464'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  ISharedProperty = interface
    function Get_Value: OleVariant;
    procedure Set_Value(pVal: OleVariant);
    property Value: OleVariant read Get_Value write Set_Value;
  end;

{ ISharedPropertyGroup }

  [ComImport,
  GuidAttribute('2A005C07-A5DE-11CF-9E66-00AA00A3F464'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  ISharedPropertyGroup = interface
    function CreatePropertyByPosition(Index: Integer{+ ! SYSINT}; out fExists: WordBool): ISharedProperty;
    function Get_PropertyByPosition(Index: Integer{+ ! SYSINT}): ISharedProperty;
    function CreateProperty(const Name: WideString; out fExists: WordBool): ISharedProperty;
    function Get_PropertyByName(const Name: WideString): ISharedProperty;
    property PropertyByPosition[Index: Integer{+ ! SYSINT}]: ISharedProperty read Get_PropertyByPosition;
    property PropertyByName[const Name: WideString]: ISharedProperty read Get_PropertyByName;
  end;

{ ISharedPropertyGroupManager }

  [ComImport,
  GuidAttribute('2A005C0D-A5DE-11CF-9E66-00AA00A3F464'),
  InterfaceTypeAttribute(ComInterfaceType.InterfaceIsIDispatch)]
  ISharedPropertyGroupManager = interface
    function CreatePropertyGroup(const Name: WideString; var LockMode: Integer;
      var RelMode: Integer; out fExists: WordBool): ISharedPropertyGroup;
    function Get_Group(const Name: WideString): ISharedPropertyGroup;
    function Get__NewEnum: TObject; // IUnknown
    property Group[const Name: WideString]: ISharedPropertyGroup read Get_Group;
    property _NewEnum: TObject read Get__NewEnum;
  end;

{ Object APIs }

function GetObjectContext: IObjectContext;
function SafeRef(const rid: TGUID; Unk: TObject): TObject;

{ Client APIs }

function CreateTransactionContext: ITransactionContext;
function CreateTransactionContextEx: ITransactionContextEx;

{ Server APIs }

function CreateSharedPropertyGroupManager: ISharedPropertyGroupManager;
function CreateSharedPropertyGroup(const Name: WideString): ISharedPropertyGroup;

implementation

uses System.Security, ComObj;

const
  Ole32 = 'ole32.dll';
  MtxEx = 'mtxex.dll';

[SuppressUnmanagedCodeSecurity, DllImport(MtxEx, CharSet = CharSet.Ansi, SetLastError = True,
 CallingConvention=CallingConvention.Cdecl, EntryPoint = 'GetObjectContext')]
function GetObjectContextProc(var ObjectContext: IObjectContext): HRESULT; external;

[SuppressUnmanagedCodeSecurity, DllImport(Ole32, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CoGetObjectContext')]
function CoGetObjectContext([MarshalAs(UnmanagedType.LPStruct)] riid: TGUID;
  var ObjectContext: IObjectContext): HRESULT; external;

[SuppressUnmanagedCodeSecurity, DllImport(MtxEx, CharSet = CharSet.Ansi, SetLastError = True,
 CallingConvention=CallingConvention.Cdecl, EntryPoint = 'SafeRef')]
[result: MarshalAs(UnmanagedType.IUnknown)]
function SafeRefProc([MarshalAs(UnmanagedType.LPStruct)] rid: TGUID;
  [MarshalAs(UnmanagedType.IUnknown)] Unk: TObject): TObject; external;

var
  GetObjectContextAvailable: Boolean;
  CoGetObjectContextAvailable: Boolean;
  SafeRefAvailable: Boolean;
  MtsProcsLoaded: Boolean;

function IsComPlusPlatform: Boolean;
var
  Ver: TOsVersionInfo;
begin
  Ver.dwOSVersionInfoSize := Marshal.SizeOf(Ver);
  GetVersionEx(Ver);
  Result := (Ver.dwPlatformID = VER_PLATFORM_WIN32_NT) and (Ver.dwMajorVersion >= 5);
end;

procedure LoadMtsProcs;
var
  Mtxdll: HModule;
begin
  if MtsProcsLoaded then Exit;
  MtsProcsLoaded := True;
  if IsComPlusPlatform then
  begin
    Mtxdll := GetModuleHandle('ole32.dll');
    if Mtxdll <> 0 then
      CoGetObjectContextAvailable := GetProcAddress(Mtxdll, 'CoGetObjectContext') <> nil;
  end
  else
  begin
    Mtxdll := GetModuleHandle('mtxex.dll');
    if Mtxdll <> 0 then
    begin
      GetObjectContextAvailable := GetProcAddress(Mtxdll, 'GetObjectContext') <> nil;
      SafeRefAvailable := GetProcAddress(Mtxdll, 'SafeRef') <> nil;
    end;
  end;
end;

const
  IID_IObjectContext{: TGUID} = '{51372AE0-CAE7-11CF-BE81-00AA00A2FA25}';

function GetObjectContext: IObjectContext;
begin
  LoadMtsProcs;
  if CoGetObjectContextAvailable then
    CoGetObjectContext(TGuid.Create(IID_IObjectContext), Result)
  else if GetObjectContextAvailable then
    OleCheck(GetObjectContextProc(Result))
  else
    Result := nil;
end;

function SafeRef(const rid: TGUID; Unk: TObject): TObject;
begin
  LoadMtsProcs;
  if SafeRefAvailable then
    Result := SafeRefProc(rid, Unk)
  else
  begin
    Marshal.AddRef(Marshal.GetIUnknownForObject(Unk));
    Result := Unk;
  end;
end;

function CreateTransactionContext: ITransactionContext;
begin
  Result := CreateComObject(TGuid.Create(CLASS_TransactionContext)) as ITransactionContext;
end;

function CreateTransactionContextEx: ITransactionContextEx;
begin
  Result := CreateComObject(TGuid.Create(CLASS_TransactionContextEx)) as ITransactionContextEx;
end;

function CreateSharedPropertyGroupManager: ISharedPropertyGroupManager;
begin
  Result := CreateComObject(TGuid.Create(CLASS_SharedPropertyGroupManager)) as ISharedPropertyGroupManager;
end;

function CreateSharedPropertyGroup(const Name: WideString): ISharedPropertyGroup;
var
  Exists: WordBool;
  LockMode: Integer;
  RelMode: Integer;
begin
  LockMode := LockSetGet;
  RelMode := Process;
  with CreateSharedPropertyGroupManager do
    Result := CreatePropertyGroup(Name, LockMode, RelMode, Exists);
end;

end.
